program define prev_yr_dat 

* Pull data from previous year (like the income readings)
* into the current year.
*
* Arguments:
*  
*   1 = input variable
*   2 = output variable 
*   3 = last year of input variable (4-digits)
*

display " "
display "Unlagging data ..."
display " "
forvalues yyyy = 1968/`3' {

   local yy = substr(string(`yyyy'), 3,2)  
   local lyyyy = `yyyy' - 1
   local lyy = substr(string(`lyyyy'), 3,2)  
   capture gen `2'`yy' = `1'`lyy'
   if _rc == 111 {
     display "The variable `1' is not available in `lyyyy'."
   }
}   

drop `1'6* `1'7* `1'8* `1'9* `1'0*
sort persid
quietly compress

end


